/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.util;

import com.andavin.util.FontCharacter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;

public final class StringUtil {
    private static final int CENTER_CHAT = 160;
    private static final int INVENTORY_LENGTH = 78;
    private static final int LORE_LENGTH = 240;
    private static final int BOOK_LENGTH = 108;

    public static List<String> splitForLore(String str) {
        String[] strings = str.split("%n");
        LinkedList<String> lines = new LinkedList<String>();
        for (String string : strings) {
            int length = 0;
            boolean isBold = false;
            boolean previousCode = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\u00a7') {
                    previousCode = true;
                    continue;
                }
                if (previousCode) {
                    previousCode = false;
                    isBold = c == 'l' || c == 'L';
                    continue;
                }
                if (c == ' ' && length > 240) {
                    lines.add("\u00a7f" + string.substring(0, i));
                    string = string.substring(i + 1);
                    length = 0;
                    i = 0;
                    continue;
                }
                FontCharacter craftChar = FontCharacter.getByCharacter(c);
                length += craftChar != null ? (isBold ? craftChar.getBold() : craftChar.getLength()) : 5;
            }
            lines.add("\u00a7f" + string);
        }
        return lines;
    }

    public static String splitForBook(String str, boolean center, ChatColor color) {
        String[] strings = StringUtils.split((String)str, (char)'\n');
        LinkedList<String> lines = new LinkedList<String>();
        for (String string : strings) {
            int length = 0;
            int lastSpace = -1;
            boolean isBold = false;
            boolean previousCode = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ' ') {
                    lastSpace = i;
                }
                if (c == '\u00a7') {
                    previousCode = true;
                } else if (previousCode) {
                    previousCode = false;
                    isBold = c == 'l' || c == 'L';
                } else {
                    FontCharacter craftChar = FontCharacter.getByCharacter(c);
                    int addition = craftChar != null ? (isBold ? craftChar.getBold() : craftChar.getLength()) : 5;
                    length += addition;
                }
                if (length < 108 || lastSpace == -1) continue;
                lines.add(string.substring(0, lastSpace));
                string = lastSpace + 1 < string.length() ? string.substring(lastSpace + 1) : "";
                lastSpace = -1;
                length = 0;
                i = 0;
            }
            lines.add(string);
        }
        if (center) {
            for (int i = 0; i < lines.size(); ++i) {
                lines.set(i, color + StringUtil.centerBookLine((String)lines.get(i)));
            }
        }
        return StringUtils.join(lines, (char)'\n');
    }

    public static String centerMessage(String msg) {
        if (msg == null || msg.isEmpty()) {
            return msg;
        }
        int length = StringUtil.getLength(msg);
        StringBuilder spaces = new StringBuilder();
        int neededSpaced = 160 - length / 2;
        for (int spaced = 0; spaced < neededSpaced; spaced += FontCharacter.SPACE.getLength()) {
            spaces.append(' ');
        }
        return spaces.append(msg).toString();
    }

    public static String centerTitle(String title) {
        if (title == null || title.isEmpty()) {
            return title;
        }
        if (title.length() >= 32) {
            return title.substring(32);
        }
        int length = StringUtil.getLength(title);
        StringBuilder spaces = new StringBuilder();
        int neededSpaced = 78 - length / 2;
        for (int spaced = 0; spaced < neededSpaced; spaced += FontCharacter.SPACE.getLength()) {
            spaces.append(' ');
        }
        return spaces.append(title).toString();
    }

    public static String centerBookLine(String line) {
        if (line == null || line.isEmpty()) {
            return line;
        }
        int length = StringUtil.getLength(line);
        if (length == 0) {
            return line;
        }
        StringBuilder spaces = new StringBuilder();
        int neededSpaced = 54 - length / 2;
        for (int spaced = 0; spaced < neededSpaced; spaced += FontCharacter.SPACE.getLength()) {
            spaces.append(' ');
        }
        return spaces.append(line).toString();
    }

    public static String centerWithBase(String str, int base) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        int length = StringUtil.getLength(str);
        StringBuilder spaces = new StringBuilder();
        int neededSpaced = (base - length) / 2;
        for (int spaced = 0; spaced < neededSpaced; spaced += FontCharacter.SPACE.getLength()) {
            spaces.append(' ');
        }
        return spaces.append(str).toString();
    }

    public static List<String> centerLines(List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return lines;
        }
        int fullSize = StringUtil.getLongestLine(lines);
        ArrayList<String> newLines = new ArrayList<String>(lines.size());
        lines.forEach(line -> {
            int length = StringUtil.getLength(line);
            StringBuilder spaces = new StringBuilder();
            int neededSpaces = (fullSize - length) / 2;
            for (int spaced = 0; spaced < neededSpaces; spaced += FontCharacter.SPACE.getLength()) {
                spaces.append(' ');
            }
            newLines.add(spaces.append((String)line).toString());
        });
        return newLines;
    }

    private static int getLongestLine(List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return 0;
        }
        int longest = 0;
        for (String line : lines) {
            int length = StringUtil.getLength(line);
            if (longest >= length) continue;
            longest = length;
        }
        return longest;
    }

    static int getLength(String str) {
        int length = 0;
        boolean isBold = false;
        boolean previousCode = false;
        for (char c : str.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            FontCharacter fontChar = FontCharacter.getByCharacter(c);
            length += fontChar != null ? (isBold ? fontChar.getBold() : fontChar.getLength()) : 5;
        }
        return length;
    }
}

